/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.yaml;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.SingleTokenScanner;
import com.aptana.editor.common.text.rules.CommentScanner;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.yaml.YAMLCodeScanner;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.source.ISourceViewer;

public class YAMLSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__yaml_";
    public static final String DEFAULT = "__yaml___dftl_partition_content_type";
    public static final String DIRECTIVE = "__yaml_directive";
    public static final String STRING_SINGLE = "__yaml_string_single";
    public static final String STRING_DOUBLE = "__yaml_string_double";
    public static final String INTERPOLATED = "__yaml_interpolated";
    public static final String COMMENT = "__yaml_comment";
    public static final String[] CONTENT_TYPES = new String[]{"__yaml___dftl_partition_content_type", "__yaml_directive", "__yaml_comment", "__yaml_string_single", "__yaml_string_double", "__yaml_interpolated"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.yml"}};
    private IPredicateRule[] partitioningRules;
    private static YAMLSourceConfiguration instance;

    static {
        IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.yml"}), new QualifiedContentType(new String[]{"source.yaml"}));
        c.addTranslation(new QualifiedContentType(new String[]{COMMENT}), new QualifiedContentType(new String[]{"comment.line.number-sign.yaml"}));
        c.addTranslation(new QualifiedContentType(new String[]{STRING_SINGLE}), new QualifiedContentType(new String[]{"string.quoted.single.yaml"}));
        c.addTranslation(new QualifiedContentType(new String[]{STRING_DOUBLE}), new QualifiedContentType(new String[]{"string.quoted.double.yaml"}));
        c.addTranslation(new QualifiedContentType(new String[]{INTERPOLATED}), new QualifiedContentType(new String[]{"string.interpolated.yaml"}));
        c.addTranslation(new QualifiedContentType(new String[]{DIRECTIVE}), new QualifiedContentType(new String[]{"meta.tage.directive.yaml"}));
    }

    public static YAMLSourceConfiguration getDefault() {
        if (instance == null) {
            instance = new YAMLSourceConfiguration();
        }
        return instance;
    }

    private YAMLSourceConfiguration() {
        EndOfLineRule directiveRule = new EndOfLineRule("%", this.getToken(DIRECTIVE));
        directiveRule.setColumnConstraint(0);
        this.partitioningRules = new IPredicateRule[]{new SingleLineRule("`", "`", this.getToken(INTERPOLATED), '\\'), new SingleLineRule("'", "'", this.getToken(STRING_SINGLE), '\\'), new SingleLineRule("\"", "\"", this.getToken(STRING_DOUBLE), '\\'), new EndOfLineRule("#", this.getToken(COMMENT)), directiveRule};
    }

    public String[] getContentTypes() {
        return CONTENT_TYPES;
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SubPartitionScanner(this.partitioningRules, CONTENT_TYPES, this.getToken(DEFAULT));
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.yml";
        }
        return null;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer((ITokenScanner)new YAMLCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        dr = new ThemeingDamagerRepairer(this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, COMMENT);
        dr = new ThemeingDamagerRepairer(this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_SINGLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_SINGLE);
        dr = new ThemeingDamagerRepairer(this.getDoubleStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_DOUBLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_DOUBLE);
        dr = new ThemeingDamagerRepairer(this.getInterpolatedScanner());
        reconciler.setDamager((IPresentationDamager)dr, INTERPOLATED);
        reconciler.setRepairer((IPresentationRepairer)dr, INTERPOLATED);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        return new CommonContentAssistProcessor(editor);
    }

    private ITokenScanner getCommentScanner() {
        return new CommentScanner(this.getToken("comment.line.number-sign.yaml"));
    }

    private ITokenScanner getStringScanner() {
        return new SingleTokenScanner(this.getToken("string.quoted.single.yaml"));
    }

    private ITokenScanner getDoubleStringScanner() {
        return new SingleTokenScanner(this.getToken("string.quoted.double.yaml"));
    }

    private ITokenScanner getInterpolatedScanner() {
        return new SingleTokenScanner(this.getToken("string.interpolated.yaml"));
    }

    private IToken getToken(String name) {
        return CommonUtil.getToken((String)name);
    }
}

